
public class KarelWorld {
	private int rows, cols;
	private KarelRobot karel = new KarelRobot(0, 0);
	
	private WallPosition[][] walls;
	
	public KarelWorld(int rows, int cols) {
		this.rows = rows;
		this.cols = cols;
		
		initWalls(rows, cols);
	}
	
	private void initWalls(int rows, int cols) {
		walls = new WallPosition[rows + 1][cols + 1];
		
		for (int row = 0; row < rows + 1; row++) {
			for (int col = 0; col < cols + 1; col++) {
				walls[row][col] = new WallPosition();
			}
		}
		
		for (int row = 0; row < rows; row++) {
			walls[row][0].setWallToWest(true);
			walls[row][cols].setWallToWest(true);
		}
		
		for (int col = 0; col < cols; col++) {
			walls[0][col].setWallToSouth(true);
			walls[rows][col].setWallToSouth(true);
		}
	}
	
	public int numRows() {
		return rows;
	}
	
	public int numCols() {
		return cols;
	}
	
	public KarelRobot getKarel() {
		return karel;
	}
	
	
	public void move() {
		if (karel.getDirection().equals("North")) {
			karel.setPosition(karel.getRow() + 1, karel.getColumn());
		} else if (karel.getDirection().equals("South")) {
			karel.setPosition(karel.getRow() - 1, karel.getColumn());
		} else if (karel.getDirection().equals("East")) {
			karel.setPosition(karel.getRow(), karel.getColumn() + 1);
		} else {
			karel.setPosition(karel.getRow(), karel.getColumn() - 1);
		} 
	}
	
	public void turnLeft() {
		karel.turnLeft();
	}
}
